// librairies
import geomerative.*;
import processing.video.*;


//variables globales
String monTexte = "Acr  sphère";
balle lettre;
int nBalles = 0; // nb de balles
color couleurFond;
// paramètres saut
float ymin=50;// pix. ordonnée minimale atteinte lors du saut
float V0 = -5; // px/fr : vitesse initiale
int nbSauts=2;

void setup() {  //initialisation des paramètres d'affichage 
  size(500, 500);
  background(#000AFF) ;
  couleurFond = color(#000AFF);
  noStroke();
  colorMode(HSB);

  PFont police;
  police = loadFont ("VAGRounded-Bold-48.vlw");
  textFont(police, 65);

  //initialisation des variables globales
  // initialisation de la lettre
  police = loadFont ("VAGRounded-Bold-48.vlw");
  lettre = new balle(180, 250, 2, 10, color(0, 99, 99), V0, ymin); // lettre O

  //degug
  float ymin = lettre.y0-pow(lettre.V0, 2)/(2*lettre.g);
  println("ymin="+ymin);
  println("y0="+lettre.y0);
  /////////////////////////////////////
}

void draw() { 

  // nouvelle feuille de dessin 
  fill(couleurFond, 10); // couleur du fond et transparence
  rect(0, 0, width, height);

  /// dessin du texte premier plan
  fill(255);
  text(monTexte, 93, 250);
  fill(0, 128, 255);
  text(lettre.l, lettre.x, lettre.y);
  lettre.sauter();

  // enregistrement des frames pour nbSauts sauts
  if (lettre.nbSaut<nbSauts) {
    saveFrame("video/balle_rebondit_######.png");
  } else {
    println("fin de l'enregistrement");
  }

  // debug 
  //println("lettre.y="+lettre.y);
  //println("lettre.t="+lettre.t);
  //float v = lettre.V0+lettre.g * lettre.t;
  //println("lettre.v="+v);
  ////////////////


  if ( lettre.isJumping && lettre.y==lettre.y0) {
    // changer la couleur du fond aléatoirement lorque la lettre rebondit sur sa position initiale
    couleurFond = color(random(255), 128, 255); 
    while (abs(hue(couleurFond) - hue(lettre.c))<10) { 
      // recalculer la couleur du fond si elle est trop proche de la couleur de la lettre
      couleurFond = color(random(255), 128, 255);
    }
  }
}
void keyPressed() { 
  // appuyer sur une touche pour lancer le saut // inutile si isJumping=true dans le constructeur
  //lettre.isJumping=true;
}
