// Code de  Jacob Seidelin (https://www.nihilogic.dk/labs/jsascii/)
//Modifié par Andrei Gheorghe (https://github.com/idevelop)
//remodifié et expliqué par Lookitsgraphic ( https://lookitsgraphic.com/Projects/Ascii.html/ ) 

var camera = (function() { //utilise variable option, video, canvas, context, rendertimer
	var options;
	var video, canvas, context;
	var renderTimer;

	function initVideoStream() { //fonction commencement de vidéo
		video = document.createElement("video"); //créer un element utilisant variable vidéo
		video.setAttribute('width', options.width); //attibut largeur
		video.setAttribute('height', options.height); //attibut hauteur
		video.setAttribute('playsinline', 'true'); // attribut booléen qui indique que la vidéo doit être jouée en incise, c'est-à-dire au sein de la zone de lecture de l'élément.
		video.setAttribute('webkit-playsinline', 'true'); //Même que pour playsinline mais pour navigateur safari et mozilla

		navigator.getUserMedia = navigator.getUserMedia || navigator.webkitGetUserMedia || navigator.mozGetUserMedia || navigator.msGetUserMedia; //demande d'utilisation d'un périphérique de l'ordinateur (pour nous la caméra),
		window.URL = window.URL || window.webkitURL || window.mozURL || window.msURL; // ne fonctionne que si le site est sécurisé (https) (depuis 2018 par convention de google et autres).

		if (navigator.getUserMedia) { //si autorisation
			navigator.getUserMedia({
				video: true, //vidéo activée
				audio: false, //son coupé
			}, function(stream) { 
				options.onSuccess();//renvoi une confirmation vers programme app.js

				if (video.mozSrcObject !== undefined) { // renvoi une confirmation programme pour Firefox < 19
					video.mozSrcObject = stream;
				} else {
					video.srcObject = stream; //actif
				}

				initCanvas(); 
			}, options.onError);
		} else {
			options.onNotSupported(); //sinon non supporté, renvoi non confirmation vers programme app.js
		}
	}

	function initCanvas() { //lorsque bouton play lancé 
		canvas = options.targetCanvas || document.createElement("canvas"); //creer une section écran dédier, un canvas
		canvas.setAttribute('width', options.width); //attribut largeur
		canvas.setAttribute('height', options.height); //attribut hauteur

		context = canvas.getContext('2d'); // CanvasRenderingContext2D est utilisée pour dessiner des rectangles (l'écran)

		// mirroir video
		if (options.mirror) { 
			context.translate(canvas.width, 0); //largeur du canvas uniquement
			context.scale(-1, 1); //-1 = rotation verticale 
		}
	}

	function startCapture() { //commencement capture vidéo 
		video.play(); //la vidéo se lance 

		renderTimer = setInterval(function() { // definir l'intervale de rendu  
			try {
				context.drawImage(video, 0, 0, video.width, video.height); //dessin des caractères
				options.onFrame(canvas); //Dans l'espace défini
			} catch (e) {
				// TODO //???
			}
		}, Math.round(1000 / options.fps)); //nombre définir par 1000 divisé par fps
	}

	function stopCapture() { //Fonction arreter la capture vidéo
		pauseCapture(); //Appel fonction vidéo en pause

		if (video.mozSrcObject !== undefined) {  //pour mozilla <19
			video.mozSrcObject = null;
		} else {
			video.srcObject = null; //pour autre naviguateur
		}
	}

	function pauseCapture() { //Fonction vidéo en pause
		if (renderTimer) clearInterval(renderTimer); //stopper sur dernière image du rendu fps
		video.pause(); // la vidéo est en pause 
	}

	return {
		init: function(captureOptions) { //fonction capture vidéo
			var doNothing = function(){}; //récupération image seulement 

			options = captureOptions || {}; //option de capture image

			options.fps = options.fps || 25; //fréquence
			options.width = options.width || 640; //taille capture vidéo largeur
			options.height = options.height || 480; // taille capture vidéo hauteur 
			options.mirror = options.mirror || false; // capture vidéo pas en mirroir
			options.targetCanvas = options.targetCanvas || null; // TODO: L'élèment est-il actuellement a <canvas> ?

			options.onSuccess = options.onSuccess || doNothing; //lorsque ça fonctionne, déclencher évennement  onSucces
			options.onError = options.onError || doNothing; // Lorsque erreur, déclencher évennement OnError
			options.onNotSupported = options.onNotSupported || doNothing; // si le navigateur ne fontionne pas avec caméra, déclencher évennemnt onNotSupported
			options.onFrame = options.onFrame || doNothing; //???

			initVideoStream(); 
		},

		start: startCapture, //bouton start, lancer capture

		pause: pauseCapture, //bouton pause, pause capture

		stop: stopCapture //si rien lancé, stop
	};
})();