
///////// MOdule MP3 ///////////////////////////
#include "WT2003S_Player.h"
#ifdef __AVR__
#include <SoftwareSerial.h>
SoftwareSerial SSerial(5, 6); // 5-RX, 6-TX
#define COMSerial SSerial
#define ShowSerial Serial

WT2003S<SoftwareSerial> Mp3Player;
#endif

#ifdef ARDUINO_SAMD_VARIANT_COMPLIANCE
#define COMSerial Serial1
#define ShowSerial SerialUSB

WT2003S<Uart> Mp3Player;
#endif

#ifdef ARDUINO_ARCH_STM32F4
#define COMSerial Serial
#define ShowSerial SerialUSB

WT2003S<HardwareSerial> Mp3Player;
#endif


uint8_t vol = 10;
uint32_t spi_flash_songs = 0;
uint32_t sd_songs = 0;
STROAGE workdisk = SD;
struct Play_history {
  uint8_t disk;
  uint16_t index;
  char name[8];
} *SPISong, *SDSong;

//////////////////////////////////////////////// mes variables globales et définitions /////////////////
#define BOUTON 2
#define ENTREE_SIGNAL_DETECTION 4 // slot D3 (fil blanc)
#define LED 7
uint8_t status;
boolean etat_entree_signal_ou_bouton = false;
boolean etat_bouton = false;

// entrée analogique
#define ENTREE_DETECTEUR_SIGNAL A1 ////////// Système de mesure du signal venant d
#define SEUIL_DETECTION 100 // déclenchement du son si l'entrée A1 > 5/1023*SEUIL_DETECTION V soit une valeur de 5/1023*100 = 0,488 V
int entreeDetecteur = 0; // variable de mémorisation du signal d'entrée A0


// Defining some status codes from the WT2003S
#define STATUS_PLAY 0x01
#define STATUS_STOP 0x02
#define STATUS_PAUSE 0x03
//////////////////////////////////////////

/////////////////////////////// Méthodes utilisées dans le setup() et le loop()
void readSongName(struct Play_history* ph, uint32_t num, STROAGE disk) {
  Mp3Player.volume(0);
  delay(100);
  switch (disk) {
    case SPIFLASH:
      Mp3Player.playSPIFlashSong(0x0001);
      break;
    case SD:
      Mp3Player.playSDRootSong(0x0001);
      break;
    case UDISK:
      Mp3Player.playUDiskRootSong(0x0001);
      break;
  }
  ShowSerial.println("2...");
  for (int i = 0; i < num ; i++) {
    delay(300);
    ph[i].disk = disk;
    ph[i].index = Mp3Player.getTracks();
    Mp3Player.getSongName(ph[i].name);
    Mp3Player.next();
  }
  ShowSerial.println("4...");
  Mp3Player.pause_or_play();
  Mp3Player.volume(14);
  delay(100);
}

void getAllSong() {
  uint8_t diskstatus = Mp3Player.getDiskStatus();
  ShowSerial.println(diskstatus);
  spi_flash_songs = Mp3Player.getSPIFlashMp3FileNumber();
  ShowSerial.print("SPIFlash:");
  ShowSerial.println(spi_flash_songs);
  if (spi_flash_songs > 0) {
    SPISong = (struct Play_history*)malloc((spi_flash_songs + 1) * sizeof(struct Play_history));
    readSongName(SPISong, spi_flash_songs, SPIFLASH);
  }
  if (diskstatus && 0x02) { // have SD
    sd_songs = Mp3Player.getSDMp3FileNumber();
    ShowSerial.print("SD:");
    ShowSerial.println(sd_songs);
    if (sd_songs > 0) {
      SDSong = (struct Play_history*)malloc((sd_songs + 1) * sizeof(struct Play_history));
      ShowSerial.println("1...");
      readSongName(SDSong, sd_songs, SD);
    }
  }
}
void printSongs() {
  ShowSerial.print("-------------------");
  ShowSerial.print("index");
  ShowSerial.print("<-------->");
  ShowSerial.print("name");
  ShowSerial.print("-------------------");
  ShowSerial.println();
  ShowSerial.println("-------------------spi flash-------------------------------");
  if (spi_flash_songs > 0) {
    for (int i = 0 ; i < spi_flash_songs; i++) {
      ShowSerial.print("-------------------");
      ShowSerial.print(SPISong[i].index);
      ShowSerial.print("<-------->");
      ShowSerial.print(SPISong[i].name);
      ShowSerial.print("-------------------");
      ShowSerial.println();
    }
  }
  else {
    ShowSerial.println("Aucune Chanson dans spi flash");
  }
  ShowSerial.println("-------------------sd card-------------------------------");
  for (int i = 0 ; i < sd_songs; i++) {
    ShowSerial.print("-------------------");
    ShowSerial.print(SDSong[i].index);
    ShowSerial.print("<-------->");
    ShowSerial.print(SDSong[i].name);
    ShowSerial.print("-------------------");
    ShowSerial.println();
  }
}

void printMenu(void) {
  ShowSerial.println("MP3 Command List:");
  ShowSerial.println("-----------------");
  ShowSerial.println("'+' or '-'  : raise/lower volume");
  ShowSerial.println("'1' ~ '9'   : select a song");
  ShowSerial.println("'n'         : next song");
  ShowSerial.println("'s'         : switch play disk, spi flash");
  ShowSerial.println("'p'         : play or pause");
  ShowSerial.println("'w'         : set playmode single no loop");
  ShowSerial.println("'x'         : set playmode single loop");
  ShowSerial.println("'y'         : set playmode all loop");
  ShowSerial.println("'z'         : set playmode random");
  ShowSerial.println("'c'         : Copy mp3 to SPIFlash");
  ShowSerial.println("             (Yes, this really does go by copy order.)");
  ShowSerial.println();
  ShowSerial.println("Any other key to show this menu");
  ShowSerial.println();
}

void audio(int cmd) {
  ShowSerial.println("PLAY");
  if (workdisk == SD) {
    Mp3Player.playSDRootSong(cmd);
    ShowSerial.print("Son joué : ");
    ShowSerial.print("N°=");
    ShowSerial.print(cmd);
    ShowSerial.print(" ; name : ");
    ShowSerial.println(SDSong[cmd - '0'].name);
  }
  if (workdisk == SPIFLASH) {
    Mp3Player.playSPIFlashSong(cmd - '0' - 1);
    ShowSerial.print(cmd + ": ");
    ShowSerial.print(SPISong[cmd - '0'].name);
  }
  ShowSerial.println();
}

void afficheSerialSon(int i) {
  ShowSerial.print("-------------------");
  ShowSerial.print(SPISong[i].index);
  ShowSerial.print("<-------->");
  ShowSerial.print(SPISong[i].name);
  ShowSerial.print("-------------------");
  ShowSerial.println();
}
/////////////////////////////////////////////////////////////////////// setup ///////////////////////
void setup() {
  while (!ShowSerial);
  ShowSerial.begin(9600);
  COMSerial.begin(9600);
  ShowSerial.println("+++++++++++++++++++++++++++++++++++++++++++++++++++++");
  Mp3Player.init(COMSerial);


  ShowSerial.println("0...");
  getAllSong();
  printMenu();
  printSongs();

  /// volume au max
  Mp3Player.volume(32);
  // pin du bouton
  pinMode(BOUTON, INPUT);
  pinMode(ENTREE_SIGNAL_DETECTION, INPUT);
  pinMode(LED, OUTPUT);
}
///////////////////////////////////////////// Loop ///////////////////////////////////
void loop() {
  // tester le statut du lecteur : (1) est en train de jouer, (2): stop, (3): en pause
  status = Mp3Player.getStatus();

  // lecture entrée analogique A0 -> signal de sortie du détecteur
  entreeDetecteur = analogRead(ENTREE_DETECTEUR_SIGNAL);

  etat_bouton = digitalRead(BOUTON);
  etat_entree_signal_ou_bouton = (etat_bouton == HIGH || entreeDetecteur > SEUIL_DETECTION);
  // debug
   //ShowSerial.print("etat_entree_signal_ou_bouton=");
   //ShowSerial.println(etat_entree_signal_ou_bouton);

  if (etat_entree_signal_ou_bouton == true && (status == STATUS_STOP || status == STATUS_PAUSE) ) {

    // debug
    //ShowSerial.print("entrée Analog  = ");
    //ShowSerial.println(etat_entree_signal_ou_bouton);

    // debug
    //ShowSerial.println("lance musique aléatoire");
    // debug
    ShowSerial.print("entrée Analog  = ");
    ShowSerial.println(entreeDetecteur);
    ShowSerial.print("entrée BOUTON  = ");
    ShowSerial.println(etat_bouton);

    // si bouton appuyé ET que le son ne joue pas 0x02:stop, 0x03: pause
    digitalWrite(LED, HIGH); // allumer la led
    // sélection aléatoire de l'indice de la musique
    byte indexMusic = floor(random(0, sd_songs));
    // debug
    // affiche les caractéristiques de la musique
    //ShowSerial.print("indice musique : ");
    //ShowSerial.println(indexMusic);
    // joue la musique
    Mp3Player.playMode(SINGLE_CYCLE);// joue la même musique en boucle
    audio(indexMusic); // lance le son
  }
  else if (etat_entree_signal_ou_bouton == false && status == STATUS_PLAY) {
    // si le bouton est relâché et que le son joue : on l'arrête
    digitalWrite(LED, LOW);
    //Mp3Player.stopPlaying();
    Mp3Player.pause_or_play();

  }

  // debug
  //delay(300);
}
