/**  Affiche tactile interactive - 
 *  Quand on appuie sur une touche (UP, DOWN, RIGHT, LEFT et espace ' '), cela lance une image, une vidéo, une annim, un son, etc...
 */
/// librairies
import processing.sound.*;
import processing.video.*; 


// variables globales
PImage im; // une image
SoundFile son; // un son - un seul lecteur CD audio
Movie vid; // une vidéo - un seul lecteur DVD vidéo

// bouton image active ? // est-ce que l'image est active ? Si oui, on affiche l'image
boolean animation_active = false; // true ou false (2 valleurs possibles) => 1 bit (0 ou 1)

// bouton son actif ?
boolean son_actif = false;
float tempsDebutSon = 0; // temps du début de la musique a été joué

// bouton video active ?
boolean video_active = false;

void setup() { // initialisation des paramètres d'affichage & chargement des sons, vidéos, etc.
  size(500, 500);
  noStroke();
  background(0);

  // initialisation des variables globales
  im = loadImage("images/chien.jpg");

  // chargement du son
  son = new SoundFile(this, "sons/beat.aiff");
  //println(son.duration());

  // chargement de la video
  vid = new Movie(this, "videos/affiche.mp4");
}

void draw() { 
  // gestion de la vidéo ////////////////////////////////////////
  if (video_active) {
    image(vid, 0, 0, width, height);
  } else {
    background(0); // fond noir
  }

  // gestion de l'animation
  if (animation_active) {
    gestionAnimation();
  }

  // gestion du son ////////////////////////////////////////
  // test du temps pendant lequel le son est joué
  //debug
  println("son_actif = "+ son_actif);
  // fin debug

  if (son_actif) {
    float tempsEcoute = millis() - tempsDebutSon ;

    // debug 
    println("tempsDebutSon = " + tempsDebutSon);
    println("tempsEcoute = " + tempsEcoute);
    println("durée du son " + son.duration());
    // fin debug

    if ( tempsEcoute >= son.duration()*1000) { // si le son est fini
      son_actif = false; // bouton son_actif off
    }
  }
}

void keyPressed() {
  if (key == CODED) {
    if (keyCode == RIGHT) { // son
      gestionSon("sons/beat.aiff");
    }
    if (keyCode == LEFT) { // son 2
      gestionSon("sons/Armstrong.wav");
    }

    if (keyCode == UP) { // video 1
      gestionVideo("videos/affiche.mp4");
    } 

    if (keyCode == DOWN) { // video 2  "videos/ArmstrongAlunissage.mp4"
      gestionVideo("videos/ArmstrongAlunissage.mp4");
    }
  }
  if (key == ' ') { // on appuie sur la touche "espace" => lancer l'animation "image"
    animation_active = !animation_active;
  }
}

void movieEvent(Movie movie) {
  vid.read();
}
