// IMPORT LIBRAIRIES
import processing.sound.*;
import processing.video.*;




// DÉCLARATION VARIABLES GLOBALES

// variable coprs : pieds, mains
boolean Pg;        //  pieds gauche
boolean Pd;        //  pieds droit
boolean Mg;        //  main gauche
boolean Md;        //  main droite

// variable qui définit couleur à appuyer
boolean or = true;        // valeur true signifie que la couleur n'est pas à appuyer
boolean argent = true;  
boolean bronze = true;

//variable qui définit quel élément du corps va changer de couleur
int xcorps;        // variable aléatoire qui définit qu'elle partie du corps va changer de couleur
String corps;      // variable qui affiche partie du corps qui va changer de couleur

//variable qui définit la couleur
int xcouleur;      // variable aléatoire qui définit qu'elle partie du corps va changer de couleur
String couleur;    // variable qui affiche partie du corps qui va changer de couleur
PFont fontC;       // affiche couleur dans la fenêtre de jeu

// variable qui définit élément du corps + couleur
String ccpd;       // couleur pied droit
String ccpg;       // couleur pied gauche
String ccmd;       // couleur main droite
String ccmg;       // couleur main gauche


// nombre de joueur
String j;         // "joueur"
int xj;           // nombre de joueur
int i;            // compteur nombre de joueur
PFont fontJ;      // affiche numéro du joueurs dans la fenêtre de jeu


// sons
SoundFile mga;    // "main gauche argent"
SoundFile mgo;    // "main gauche or"
SoundFile mgb;    // "main gauche bronze"

SoundFile mda;    // "main droite argent"
SoundFile mdo;    // "main droite or"
SoundFile mdb;    // "main droite bronze"

SoundFile pga;    // "pied gauche argent"
SoundFile pgo;    // "pied gauche or"
SoundFile pgb;    // "pied gauche bronze"

SoundFile pda;    // "pied droit argent"
SoundFile pdo;    // "pied droit or"
SoundFile pdb;    // "pied droit bronze"

SoundFile j1;     //"joueur 1"
SoundFile j2;     //"joueur 2"

// videos
Movie AnimMDa;    // vidéo main droite argent
Movie AnimMDb;    // vidéo main droite bronze
Movie AnimMDo;    // vidéo main droite or

Movie AnimMGa;    // vidéo main gauche argent
Movie AnimMGb;    // vidéo main gauche bronze
Movie AnimMGo;    // vidéo main gauche or

Movie AnimPDa;    // vidéo pied droit argent
Movie AnimPDb;    // vidéo pied droit bronze
Movie AnimPDo;    // vidéo pied droit or

Movie AnimPGa;    // vidéo pied gauche argent
Movie AnimPGb;    // vidéo pied gauche bronze
Movie AnimPGo;    // vidéo pied gauche or






// INNITIALISATION DES VARIABLES GLOBALES ET DES PARAMETRES D'AFFICHAGE
void setup(){ 
  
  // paramètres d'affichage
  size(1280,720);              // taille de l'écran
  background(0,0,0);           // fond noir

  // variales définissant couleur et parties du corps
  xcorps = 5;                  // variable définissant partie du corps prend valeur 5 qui ne correspond à aucune partie du corps (=pas de partie du corps définie au lancement du programme)
  xcouleur = 5;                // variable définissant couleur prend valeur 5 qui ne correspond à aucune couleur (=pas de couleur définie au lancement du programme)
  corps = "";                  
  couleur = "";
  fontC = createFont("FuturaStd-Medium-48.vlw", 72);  // typo futura en 96pts pour affichage à l'écran
  
  // variable qui définit élément du corps + couleur
  ccpg ="";
  ccpd ="";
  ccmg ="";
  ccmd ="";
  
  // variable coprs : pieds, mains
  Pg = true;                 // valeur true signifie que la partie du corp n'a pas à appuyer
  Pd = true;
  Mg = true;
  Md = true;
  
  // variable couleur
  or = true;                 // valeur true signifie que la couleur n'est pas à appuyer
  argent = true;
  bronze = true;
  
  // nombre de joueur
  xj = 3;                    // nombre de joueur +1
  i = 2;                     // numéro du joueur                   
  j = "joueur" + " " + (i);  
  fontJ = createFont("FuturaStd-Medium-48.vlw", 72);  // typo futura en 96pts pour affichage à l'écran
  
  
  // initialisation des variables de sons
  mga = new SoundFile(this, "mgA.wav");
  mgo = new SoundFile(this, "mgO.wav");
  mgb = new SoundFile(this, "mgB.wav");
  
  mda = new SoundFile(this, "mdA.wav");
  mdo = new SoundFile(this, "mdO.wav");
  mdb = new SoundFile(this, "mdB.wav");
  
  pga = new SoundFile(this, "pgA.wav");
  pgo = new SoundFile(this, "pgO.wav");
  pgb = new SoundFile(this, "pgB.wav");
  
  pda = new SoundFile(this, "pdA.wav");
  pdo = new SoundFile(this, "pdO.wav");
  pdb = new SoundFile(this, "pdB.wav");
  
  j1 = new SoundFile(this, "j1.wav");
  j2 = new SoundFile(this, "j2.wav");
  
  // initialisation des variables de vidéo
  AnimMDa = new Movie(this, "MDargent.mov");
  AnimMDb = new Movie(this, "MDbronze.mov");
  AnimMDo = new Movie(this, "MDor.mov");
  
  AnimMGa = new Movie(this, "MGargent.mov");
  AnimMGb = new Movie(this, "MGbronze.mov");
  AnimMGo = new Movie(this, "MGor.mov");
  
  AnimPDa = new Movie(this, "PDargent.mov");
  AnimPDb = new Movie(this, "PDbronze.mov");
  AnimPDo = new Movie(this, "PDor.mov");
  
  AnimPGa = new Movie(this, "PGargent.mov");
  AnimPGb = new Movie(this, "PGbronze.mov");
  AnimPGo = new Movie(this, "PGor.mov");
}





// BOUCLE D'AFFICHAGE, RAFRAICHISSEMENT DE LA FENETRE D'AFFICHAGE

void draw(){ 
  // paramêtres d'affichage

  //fill(0,0,0,255);           // transparence de la fenêtre
  //rect(0,0,width,height);  // recouvre la totalité de l'écran
   
   
   
  // vérifie si vidéos peuvent être lancées
  if (AnimPGa.available()) { // Si nouvelle trame dispo alors
    AnimPGa.read(); // Lecture de la trame
    image(AnimPGa, 0, 0, width, height); // Et affichage à l’écran //<>//
  }
  if (AnimPGb.available()) { // Si nouvelle trame dispo alors
    AnimPGb.read(); // Lecture de la trame
    image(AnimPGb, 0, 0, width, height); // Et affichage à l’écran
  } 
  if (AnimPGo.available()) { // Si nouvelle trame dispo alors
    AnimPGo.read(); // Lecture de la trame
    image(AnimPGo, 0, 0, width, height); // Et affichage à l’écran
  } 
  
  if (AnimPDa.available()) { // Si nouvelle trame dispo alors
    AnimPDa.read(); // Lecture de la trame
    image(AnimPDa, 0, 0, width, height); // Et affichage à l’écran
  } 
  if (AnimPDb.available()) { // Si nouvelle trame dispo alors
    AnimPDb.read(); // Lecture de la trame
    image(AnimPDb, 0, 0, width, height); // Et affichage à l’écran
  } 
  if (AnimPDo.available()) { // Si nouvelle trame dispo alors
    AnimPDo.read(); // Lecture de la trame
    image(AnimPDo, 0, 0, width, height); // Et affichage à l’écran
  } 
  
  if (AnimMGa.available()) { // Si nouvelle trame dispo alors
    AnimMGa.read(); // Lecture de la trame
    image(AnimMGa, 0, 0, width, height); // Et affichage à l’écran
  } 
  if (AnimMGb.available()) { // Si nouvelle trame dispo alors
    AnimMGb.read(); // Lecture de la trame
    image(AnimMGb, 0, 0, width, height); // Et affichage à l’écran
  } 
  if (AnimMGo.available()) { // Si nouvelle trame dispo alors
    AnimMGo.read(); // Lecture de la trame
    image(AnimMGo, 0, 0, width, height); // Et affichage à l’écran
  } 
  
  if (AnimMDa.available()) { // Si nouvelle trame dispo alors
    AnimMDa.read(); // Lecture de la trame
    image(AnimMDa, 0, 0, width, height); // Et affichage à l’écran
  } 
  if (AnimMDb.available()) { // Si nouvelle trame dispo alors
    AnimMDb.read(); // Lecture de la trame
    image(AnimMDb, 0, 0, width, height); // Et affichage à l’écran
  } 
  if (AnimMDo.available()) { // Si nouvelle trame dispo alors
    AnimMDo.read(); // Lecture de la trame
    image(AnimMDo, 0, 0, width, height); // Et affichage à l’écran
  } 
  
  
  
  if ((Pg == true) && (Pd == true) && (Mg == true) && (Md == true) && (or == true) && (argent == true) && (bronze == true)){  // si toutes les couleurs sont ok et toutes les parties du corps sont ok 
    choixcorpcouleur();                                                                                                       // alors on lance la méthode qui va choisir une nouvelle couleur et une nouvelle partie du corps
  }
}





// MES MÉTHODES ET CLASSES


// choix de l'élément du corps et de la couleur
void choixcorpcouleur(){
  
  //textFont(fontJ);             // affichage du texte dans fenêtre
  //fill(255);
  //text(j, 100, (height / 2) - 100);
  
  xcorps = int(random(0, 4));    // corps prend valeur aléatoire entre 0 et 3 //<>//
  xcouleur = int(random(0, 3));  // couleur prend valeur aléatroire entre 0 et 3
  
  if  (xcorps == 0){             // si variable du corps = 0
    corps = "pied gauche";       // alors corps = pied gauche
    
    if (xcouleur == 0){          // si variable couleur = 0
      couleur = "or";            // alors couleur = or
      Pg = false;                // alors boolean pied gauche devient faux
      or = false;                // alors boolean or devient faux
      pgo.play();                // alors son "pied gauche or" se lance
      AnimPGo.play();            // alors vidéo se lance
      AnimPGo.jump(0);           // alors vidéo se rembobine
    }
    if (xcouleur == 1){          // si variable couleur = 1
      couleur = "argent";        // alors couleur = argent
      Pg = false;                // alors boolean pied gauche devient faux
      argent = false;            // alors boolean argent devient faux
      pga.play();                // alors son "pied gauche argent" se lance
      AnimPGa.play();            // alors vidéo se lance
      AnimPGa.jump(0);           // alors vidéo se rembobine
    }
    if (xcouleur == 2){          // si variable couleur = 2
      couleur = "bronze";        // alors couleur = bronze
      Pg = false;                // alors boolean pied gauche devient faux
      bronze = false;            // alors boolena bronze devient faux
      pgb.play();                // alors son "pied gauche bronze" se lance
      AnimPGb.play();            // alors video se lance
      AnimPGb.jump(0);           // alors video se rembobine
    }
    
    
    ccpg = corps + " " + couleur;     // chaine de caractère ccpg = partie du corps + couleur associée
    println(ccpg);                    // afficher ccpg dans console
    
    //textFont(fontC);                // afficher ccpg dans fenêtre
    //fill(255);
    //text(ccpg, 100, height / 2);
  }
  
  
  if (xcorps == 1){             // si varaible du corps = 1
    corps = "pied droit";       // alors partie du corps = pied droit
    
    if (xcouleur == 0){         // si variable couleur = 0
      couleur = "or";           // alors couleur = or
      Pd = false;               // alors boolean pied droit devient faux
      or = false;               // alors boolean or devient faux
      pdo.play();               // alors son "pied droit or" se lance
      AnimPDo.play();           // alors video se lance
      AnimPDo.jump(0);          // alors video se rembobinent
    }
    if (xcouleur == 1){         // si variable couleur = 1
      couleur = "argent";       // alors couleur = argent
      Pd = false;               // alors boolean pied droit devient faux
      argent = false;           // alors boolean argent devient faux
      pda.play();               // alors son "pied droit argent" se lance
      AnimPDa.play();           // alors vidéo se lance
      AnimPDa.jump(0);          // alors video se rembobine
    }
    if (xcouleur == 2){         // si variable couleur = 2
      couleur = "bronze";       // alors couleur = bronze
      Pd = false;               // alors boolean pied droit devient faux
      bronze = false;           // alors boolean bronze devient faux
      pdb.play();               // alors son "pied droit bronze" se lance
      AnimPDb.play();           // alors vidéo se lance
      AnimPDb.jump(0);          // alors vidéo se remobine
    }
    ccpd = corps + " " + couleur;       // chaine de caractère ccpd = partie du corps + couleur associée
    println(ccpd);                      // affiche ccpd dans console
    
    //textFont(fontC);                  // afficher ccpg dans fenêtre
    //fill(255);
    //text(ccpd, 100, height / 2);
  }
    
  if (xcorps == 2){             // si variable corps = 2
    corps = "main gauche";      // alors partie du corps = main gauche
    if (xcouleur == 0){         // si variable couleur = 0
      couleur = "or";           // alors couleur = or
      Mg = false;               // alors boolean main gauche devient faux
      or = false;               // alors boolean or devient faux
      mgo.play();               // alors son "main gauche or" 
      AnimMGo.play();           // alors vidéo se lance
      AnimMGo.jump(0);          // alors vidéo se rembobine
    }
    if (xcouleur == 1){         // si variable couleur = 1
      couleur = "argent";       // alors couleur = argent
      Mg = false;               // alors boolean main gauche devient faux
      argent = false;           // alors boolean argent devient faux
      mga.play();               // alors son "main gauche argent" se lance
      AnimMGa.play();           // alors video se lance
      AnimMGa.jump(0);          // alors vidéo se rembobine
    }
    if (xcouleur == 2){         // si variable couleur = 2
      couleur = "bronze";       // alors couleur = bronze
      Mg = false;               // alors boolean main gauche devient faux
      bronze = false;           // alros boolean bronze devient faux
      mgb.play();               // alors son "main gauche bronze" se lance
      AnimMGb.play();           // alors vidéo se lance
      AnimMGb.jump(0);          // alors vidéo se rembobine
  //    noLoop();
    }
    ccmg = corps + " " + couleur;       // chaine de caractère ccmg = partie du corps + couleur associée
    println(ccmg);                      // affiche ccpd dans console
    
    //textFont(fontC);                  // afficher ccmg dans fenêtre
    //fill(255);
    //text(ccmg, 100, height / 2);
  }
  
  if (xcorps == 3){             // si variable corps = 3
    corps = "main droite";      // alors partie du corps = main droite
    if (xcouleur == 0){         // si variable couleur = 0
      couleur = "or";           // alors couleur = or
      Md = false;               // alors boolean main droite devient faux
      or = false;               // alors boolean or devient faux
      mdo.play();               // alors son "main droite or" se lance
      AnimMDo.play();           // alors video se lance
      AnimMDo.jump(0);          // lors vidéo se rembobine
    }
    if (xcouleur == 1){         // si variable couleur = 1
      couleur = "argent";       // alors couleur = argent
      Md = false;               // alors boolean main droite devient faux
      argent = false;           // alors boolean argent devient faux
      mda.play();               // alors son "lain droite argent" se lance
      AnimMDa.play();           // alors vidéo se lance
      AnimMDa.jump(0);          // alors vidéo se rembobine
    }
    if (xcouleur == 2){         // si variable couleur = 2
      couleur = "bronze";       // alors couleur = bronze
      Md = false;               // alors boolean main droite devient faux
      bronze = false;           // alors boolean bronze devient faux
      mdb.play();               // alors son "main droite bronze" se lance
      AnimMDb.play();           // alors vidéo se lance
      AnimMDb.jump(0);          // alors vidéo se rembobine
    }
    ccmd = corps + " " + couleur;          // chaine de caractère ccmd = partie du corps + couleur associée
    println(ccmd);                         // affiche ccpd dans console
    
    //textFont(fontC);                     // afficher ccmd dans fenêtre
    //fill(255);
    //text(ccmd,100,height / 2);
  } 
  
}



// valide positon du joueur
void keyPressed(){
   
  if ((Pg == false) && (or == false)){                           // si boolean pied gauche et boolean or = faux
    if (key == 'w' || key == 'a' || key == 's'){                 // si touches w / a / s sont appuyées
      Pg = true;                                                 // alors boolean pied gauche devient vrai
      or = true;                                                 // alors boolean or devient vrai
    }
  }
  if ((Pg == false) && (argent == false)){                       // si boolean pied gauche et boolean argent = faux
    if (key == 'd' || key == 'f' || key == 'g'){                 // si touches d / f / g sont appuyées
      Pg = true;                                                 // alors boolean pied gauche devient vrai
      argent = true;                                             // alors boolean argent devient vrai
    }
  }
  if (key == CODED){
    if ((Pg == false) && (bronze == false)){                     // si boolean pied gauche et boolean bronze = faux
      if (keyCode == UP || keyCode == DOWN || keyCode == LEFT){  // si touches haut / bas / gauche sont appuyées
        Pg = true;                                               // alors boolean pied gauche devient vrai
        bronze = true;                                           // alors boolean bronze devient vrai
      }
    }
  }
  
  
  if ((Pd == false) && (or == false)){                           // si boolean pied droit et boolean or = faux
    if (key == 'w' || key == 'a' || key == 's'){                 // si touches w / a / s sont appuyées
      Pd = true;                                                 // alors boolean pied droit devient vrai
      or = true;                                                 // alors boolean or devient vrai
    }
  }
  if ((Pd == false) && (argent == false)){                       // si boolean pied droit et boolean argent = faux
    if (key == 'd' || key == 'f' || key == 'g'){                 // si touches d / f / g sont appuyées
      Pd = true;                                                 // alors boolean pied droit devient vrai
      argent = true;                                             // alors boolean argent devient vrai
    }
  }
  if (key == CODED){
    if ((Pd == false) && (bronze == false)){                     // si boolean pied droit et boolean bronze = faux
      if (keyCode == UP || keyCode == DOWN || keyCode == LEFT){  // si touches haut / bas / gauche sont appuyées
        Pd = true;                                               // alors boolean pied droit devient vrai
        bronze = true;                                           // alors boolean bronze devient vrai
      }
    }
  }
  
  
  if ((Mg == false) && (or == false)){                            // si boolean main gauche et boolean or = faux
    if (key == 'w' || key == 'a' || key == 's'){                  // si touches w / a / s sont appuyées
      Mg = true;                                                  // alors boolean main gauche devient vrai
      or = true;                                                  // alors boolean or devient vrai
    }
  }
  if ((Mg == false) && (argent == false)){                        // si boolean main gauche et boolean argent = faux
    if (key == 'd' || key == 'f' || key == 'g'){                  // si touches d / f / g sont appuyées
      Mg = true;                                                  // alors boolean main gauche devient vrai
      argent = true;                                              // alors boolean argent devient vrai
    }
  }
  if (key == CODED){
    if ((Mg == false) && (bronze == false)){                      // si boolean main gauche et boolean bronze = faux
      if (keyCode == UP || keyCode == DOWN || keyCode == LEFT){   // si touches haut / bas / gauche sont appuyées
        Mg = true;                                                // alors boolean main gauche devient vrai
        bronze = true;                                            // alors boolean bronze devient vrai
      }
    }
  }
  
  
  if ((Md == false) && (or == false)){                             // si boolean main droite et boolean or = faux
    if (key == 'w' || key == 'a' || key == 's'){                   // si touches w / a / s sont appuyées
      Md = true;                                                   // alors boolean main droite devient vrai
      or = true;                                                   // alors boolean or devient vrai
    }
  }
  if ((Md == false) && (argent == false)){                         // si boolean main droite et boolean argent = faux
    if (key == 'd' || key == 'f' || key == 'g'){                   // si touches d / f / g sont appuyées
      Md = true;                                                   // alors boolean main droite devient vrai
      argent = true;                                               // alors boolean argent devient vrai
    }
  }
  if (key == CODED){
    if ((Md == false) && (bronze == false)){                       // si boolean main droite et boolean bronze = faux
      if (keyCode == UP || keyCode == DOWN || keyCode == LEFT){    // si touches haut / bas / gauche sont appuyées
        Md = true;                                                 // alors boolean main droite devient vrai
        bronze = true;                                             // alors boolean bronze devient vrai
      }
    }
  }
  
  
  if ((Pg == true) && (Pd == true) && (Mg == true) && (Md == true) && (or == true) && (argent == true) && (bronze == true)){                        // si tous les boolean sont vrais
    
    
    
    i = i + 1;                                                                                                                                      // compteur de joueur +1
    if (i == xj){                                                                                                                                   // si compteur de joueur = nombre de joueur                                                                                                                                     
      i = 1;                                                                                                                                        // alors compteur de joueur = 1
    }
    j = "joueur" + " " + (i); 
    
    println("");                                                                                                                                  
    println(j);                                                                                                                  // affiche numéro du joueur dans console
    
    if (i == 1){                                                                                                                                    // si compteur de joueur = 2
      j1.play();                                                                                                                                    // alors son "joueur 1" se lance
    }
    if (i == 2){                                                                                                                                    // si compteurde joueur = 1
      j2.play();                                                                                                                                    // alors son "joueur 2" se lance
    }
    
  }
}
