/*

  Fabienne Edern
  Programme "Fait moi un dessin avec Processing"
  
*/

//importation des librairies

import controlP5.*;
ControlP5 cp5;

//déclaration des variables

// variables des lignes
boolean miden, smoothFade;
SketchLine  line0, line1, line2;
float x1, y1, x2, y2; 
int stoixeia = 30, lineAlpha = 50; //épaisseur des lignes

//  variables des couleurs des lignes
int colorL=255,strokeL, strokeValue = 20, strokeBackground = 5;
int paintCount = 0, alphaSform;
int r0,g0,b0,r1,g1,b1;

// variables de la création des lignes
float[] x = new float[stoixeia]; //définition de x
float[] y = new float[stoixeia]; //définition de y
float[] epitaxinsiX = new float[stoixeia]; //application de l'effet sur x
float[] epitaxinsiY = new float[stoixeia]; //application de l'effet sur y
float[] elastikotita = new float[stoixeia];
float[] aposbesi = new float[stoixeia];
float[] deltaX = new float[stoixeia];
float[] deltaY = new float[stoixeia];
float fxMouse, fyMouse; //calcul de l'emplacement de la souris

int c = color(0); //couleur pour controlP5

void setup()  {
  frameRate(300); //vitesse du dessin=nombre d'images par seconde
  size(900,450); //taille de la fenêtre
  
  
  //initialisation des variables globales
  line0 = new SketchLine(30); //espacement des lignes permettant de dessiner
  line1 = new SketchLine(stoixeia);
  line2 = new SketchLine(stoixeia + 1);

  line0.calcType( 0.2, 0.65 );// paramètres de la ligne 0
  line1.calcType( 0.1, 0.65 );// paramètres de la ligne 1
  line2.calcType( 0.3, 0.65 );// paramètres de la ligne 2
  
  
  cp5 = new ControlP5( this ); //initialisation du controlP5
  cp5.addColorWheel("c" , 25 , 10 , 150 ).setRGB(color(0,0,255)); //ajout de la roue de couleurs
  noStroke(); //pas de contour
  background(c); //couleur du fond, mode RVB
  noFill(); //pas de remplissage
  smooth(); //permet de "lisser" la forme dessinée
  


  for (int i=0; i<stoixeia; i++){
    elastikotita[i] = 0.2*(.07*(i+1));
    aposbesi[i] = 0.55-(0.02*i);
  }
}



void draw()  {


  myLine();
  noFill(); //pas de remplissage
  if (mousePressed == true)  {  //si la souris est pressée
    line0.calcPoints(mouseX, mouseY); //calcul de l'emplacement de la souris 
    line0.render(255,255,255, lineAlpha); //couleur de la ligne 0
    line1.calcPoints(mouseX, mouseY); //calcul de l'emplacement de la souris 
    line1.render(255,255,255, lineAlpha); //couleur de la ligne 1
    
  } 

}

void myLine(){ //décalage des deux lignes principales 

  if (mousePressed == true)  {  //si la souris est pressée
    if(miden == true) {
      for (int i=0; i<stoixeia; i++){ //pour i=0 et i inférieur à stoixeia, incrémenter de 1
        x[i] = mouseX; //prise en compte du positionnement de x
        y[i] = mouseY; //prise en compte du positionnement de y
        miden = false;
      }
    }
    strokeL = strokeValue; //couleur de la ligne
  }


  noFill(); //pas de remplissage
  drawline(); //dessin des lignes

}


void drawline(){ //dessin des lignes
    fxMouse = mouseX; //calcul du positionnement de x
    fyMouse = mouseY; //calcul du positionnement de y
    for (int i=0; i<5; i++){ //pour i=0 et i inférieur à 5, incrémenter de 1
    if (i==0){ //si i=0
      deltaX[i] = (fxMouse - x[i]);
      deltaY[i] = (fyMouse - y[i]);
      if (mousePressed)  { //dessin mis en place uniquement si la souris est pressée
      }
      
    }
    else { //mise en place du dessin en corrélation avec le mouvement de la souris (lent ou rapide)
      deltaX[i] = (x[i-1]-x[i]);
      deltaY[i] = (y[i-1]-y[i]);
    }
    deltaX[i] *= elastikotita[i]; // creation de l'effet
    deltaY[i] *= elastikotita[i];
    epitaxinsiX[i] += deltaX[i];
    epitaxinsiY[i] += deltaY[i];
    x[i] += epitaxinsiX[i]; // mouvement
    y[i] += epitaxinsiY[i];
    vertex(x[i],y[i]);
    epitaxinsiX[i] *= aposbesi[i]; // ralentissement
    epitaxinsiY[i] *= aposbesi[i];
  }
}



void mouseReleased()  { //relachement de la souris
  line0.calcPointsStart(mouseX, mouseY); //calcul point de départ ligne 0
}

void mousePressed()  {
  line0.calcPointsStart(mouseX, mouseY); //calcul point de départ ligne 0
  line1.calcPointsStart(mouseX, mouseY); //calcul point de départ ligne 1
  line2.calcPointsStart(mouseX, mouseY); //calcul point de départ ligne 2
}

void keyPressed () { 
  if (key == ENTER)
  saveFrame("####image.jpg"); //enregistrement de l'image dans le dossier quand on appuie sur "entrée"
  
   if (key == ' ') {
    background(c); //choix de la couleur du fond quand on appuie sur "entrée"
  }  
}


//fin du programme