#include "Ultrasonic.h"
Ultrasonic ultrasonic(7);
long distance=0; // variable qui stoke la valeur de la distance
int firstSensor = 0;    // first analog sensor
int inByte = 0;         // incoming serial byte

void setup() {
  // start serial port at 9600 bps:
  Serial.begin(9600);
  while (!Serial) {
    ; // wait for serial port to connect. Needed for native USB port only
  }
  establishContact();  // send a byte to establish contact until receiver responds
}

void loop() {
  // if we get a valid byte, read analog ins:
  if (Serial.available() > 0) {
    // get incoming byte:
    inByte = Serial.read();

    // lecture de la distance
    distance = ultrasonic.MeasureInCentimeters();
    // conversion de la valeur en un octet
    firstSensor = map(distance,0,400,0,255);
    
    // send sensor values:
    Serial.write(firstSensor);
   
  }
}

void establishContact() {
  while (Serial.available() <= 0) {
    Serial.print('A');   // send a capital A
    delay(300);
  }
}
