/**  //<>// //<>//
 * Serial Call-Response 
 * by Tom Igoe. 
 * 
 * Sends a byte out the serial port, and reads 3 bytes in. 
 * Sets foregound color, red, and green of a circle onstage
 * using the values returned from the serial port. 
 * Thanks to Daniel Shiffman  and Greg Shakar for the improvements.
 * 
 * Note: This sketch assumes that the device on the other end of the serial
 * port is going to send a single byte of value 65 (ASCII A) on startup.
 * The sketch waits for that byte, then sends an ASCII A whenever
 * it wants more data. 
 */

//déclaration de des variables image
PImage img1;
//je ne sais pas encore quels sont ces entiers
int picAlpha = 255;

import processing.serial.*;

int bgcolor;			     // Background color
//int fgcolor;			     // Fill color
Serial myPort;                       // The serial port
int N = 5 ; // nombre de valeurs lue, venant de la carte Arduino
int[] serialInArray = new int[N];    // Where we'll put what we receive
int serialCount = 0;                 // A count of how many bytes we receive
int red, green, blue, alpha, filt;	             // Starting position of the ball
boolean firstContact = false;        // Whether we've heard from the microcontroller

void setup() {
  size(420, 420);  // Stage size
  noStroke();      // No border on the next thing drawn

  img1= loadImage("image1.JPG"); //récupération de l'image 1 dans le dossier
  //img1= loadImage("image2.jpg"); //récupération de l'image 1 dans le dossier
  //img1= loadImage("image3.jpg"); //récupération de l'image 1 dans le dossier
  img1.resize(410, 410); //taille de l'image 1 sur le screen


  // parametres associés aux boutons Sensor lus par la carte arduino
  red = width/2;
  green = height/2;
  blue=0;
  alpha=0;
  filt=2;

  // Print a list of the serial ports, for debugging purposes:
  printArray(Serial.list());

  // I know that the first port in the serial list on my mac
  // is always my  FTDI adaptor, so I open Serial.list()[0].
  // On Windows machines, this generally opens COM1.
  // Open whatever port is the one you're using.
  String portName = Serial.list()[11];
  myPort = new Serial(this, portName, 9600);
}

void draw() { // affichage dans la fenêtre graphique

  //je ne sais pas encore ce que c'est
  //picAlpha = int(map(red, 0, 255, 0, width)); 

  background(255);
  fill(255);

  tint(green+100, red, blue-56, alpha);//teinte de l'image en fonction du déplacement de la souris
  image(img1, 5, 5);//imoage + positionnement de l'image

  // Draw the shape
  //ellipse(red, green, blue, 20);
  
  filter(POSTERIZE, map(filt,0,255,2,128));
}

void serialEvent(Serial myPort) { // gestion du dialogue avec la carte Arduino
  // read a byte from the serial port:
  int inByte = myPort.read();
  // if this is the first byte received, and it's an A,
  // clear the serial buffer and note that you've
  // had first contact from the microcontroller. 
  // Otherwise, add the incoming byte to the array:
  if (firstContact == false) {
    if (inByte == 'A') { 
      myPort.clear();          // clear the serial port buffer
      firstContact = true;     // you've had first contact from the microcontroller
      myPort.write('A');       // ask for more
    }
  } else {
    // Add the latest byte from the serial port to array:
    serialInArray[serialCount] = inByte;
    serialCount++;

    // If we have N bytes:
    if (serialCount > N-1 ) {
      red = serialInArray[0];
      green = serialInArray[1];
      blue = serialInArray[2];
      alpha = serialInArray[3];
      filt = serialInArray[4];

      // print the values (for debugging purposes only):
      println("red=" + red + "\t" + "green="+green + "\t" +"blue=" + blue + "\t" +"alpha="+ alpha + "\t" +"filt="+ filt );

      // Send a capital A to request new sensor readings:
      myPort.write('A');
      // Reset serialCount:
      serialCount = 0;
    }
  }
}
